//******************************************
// file			: main.c
// version		: V1.0
// brief		: main program
// note			: 
//****************************************** 
//******************************************
//Stack Pointer	=	0x23f (If use mq6821_x_startup.asm)
//Ram range = 0x40~0x23f
//******************************************
#ifndef	IO_MEM
#define	IO_MEM
#endif  
#include "MQ6821.h"
#include "MQ6812_REG_BIT.h"

void main()
{
//============================================
// setting and start TCQ00
//============================================
    P7CR.bit.b0	=1;			//set P70 output
	P7FC.bit.b0	=1;			//set P70 function mode
 	__asm("DI");	
	POFFCR0.bit.b4=1; 		//[-.TC045EN,TC023EN,TC001EN	-,-,-,TCA0EN]
							//enable TC00 and TC01 
	EIRH.bit.b4=1; 			//[-,INTTCA0,INTTC01,INTTC00	INTRTC,INTADC,INTLVD,-]
							//enable TC00 interrupt
	__asm("EI");
	T00MOD.byte=0xFA;		//[TFF0,DBE0,TCK0[3],-,TCM0]
							//<DBE0>=1,<TCK0>=111,<TCM0>=10 10λPWMģʽ
	T00REGL.byte=0x5; 		//set timer value
	T00REGH.byte=0x1; 		//set timer value = 0x0105
	T00PWML.byte=0x80; 		//set timer value
	T00PWMH.byte=0x0; 		//set timer value = 0x0080
	T001CR.bit.b0=1; 		//[-,-,-,COMPSL	  OUTAND,-,T01RUN,T00RUN]
							//start TCQ00   
	
//============================================
// setting and start TCQ01
//============================================
    P7CR.bit.b1	=1;			//set P71 output
	P7FC.bit.b1	=1;			//set P71 function mode
 	__asm("DI");	
	POFFCR0.bit.b4=1;		//[-.TC045EN,TC023EN,TC001EN	-,-,-,TCA0EN]
							//enable TC00 and TC01 
	EIRH.bit.b5=1; 			//[-,INTTCA0,INTTC01,INTTC00	INTRTC,INTADC,INTLVD,-]
							//enable TC01 interrupt
	__asm("EI");
	T01MOD.byte=0xFA;		//[TFF0,-,TCK0[3],-,TCM0]
							////<TCK>=111,<TCM>=10 10λPWMģʽ
	T01REGL.byte=0x5; 		//set timer value
	T01REGH.byte=0x1; 		//set timer value = 0x0105
	T01PWML.byte=0x80; 		//set timer value
	T01PWMH.byte=0x0; 		//set timer value = 0x0080
	T001CR.bit.b1=1; 		//[-,-,-,COMPSL	  OUTAND,-,T01RUN,T00RUN]
							//start TCQ01  	
		//****************************
		// In MQ6812A ,INTTC01(03,05)  is not enable, if T00(02,04)RUN is 0
		// it will fix in the next version
		// **************************
	
	while(1)
	{
		WDCDR.byte = 0x4e;
	}
	
	
}
